<?php

/* last update:  January 18, 2010 */

require 'start.php';

/* Below is the mucky muck you should not need to muck with! */

// Add Safety Check - cuz I am a safety girl!
if( isset($_GET['action']) && !empty($_GET['action']) )
	{$safe = array('logNotes' => 'log_notes();',
	'Install' => 'install_notes();',
	'AddRoll' => 'add_roll_form();',
	'StorageAsc' => 'storage_asc();',
	'StorageDesc' => 'storage_desc();',
	'AddLoot' => 'add_loot_form();',
	'AddLateRoll' => 'add_single_roll();',
	'RemoveItem' => 'loot_be_gone();',
	'RemoveRoll' => 'roll_be_gone();',
	'Version' => 'version_notes();',
	'DropWinner' => 'drop_winner();',
	'DropRolls' => 'drop_rolls();',
	'DropLoot' => 'drop_loot();',
	'DropAll' => 'drop_all();',
	'undoWin' => 'undo_win();',
	'AddWin' => 'add_win();',
	'btcRandom' => 'btc_random();',
	'btcLoot' => 'btc_loot();',
	'ManualLoot' => 'manual_loot_form();',
	'btcLootManual' => 'btc_loot_manual();',
	'commitWins' => 'commitWins();',
	'searchWins' => 'searchWins();');

	$index = array_key_exists($_GET['action'], $safe);

	if($index)
		{eval($safe[$_GET['action']]);}

     // if they get this, then they fed function bogus data
     else die('No hacking allowed');}

//error if there is no action stated action
else echo('sorry, you must specify an action to use this page');

// ~*~ Notes on how to log your chat in game
function log_notes()
	{html_head('- Notes:  How to ChatLog');
	html_body();
	echo <<<LOGNOTES
	<CENTER>
	<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
	<TR><TH>Chatlog Notes</TH></TR>
	<TR>
		<TD>DAoC has the ability to create a log file separate from the regular &quot;chatlog.log&quot;.  To make log parsing cleaner (aka easier for you to find the important bits), you can set a log file by name in game for each raid lotto.

		<P>Prior to starting the random rolls or loot delve, create a new log file by typing &quot;/chatlog LogName&quot;,ie:
		<P>/chatlog Aug31Dragon
		<P>To stop the logging, just type &quot;l&quot; (L), then in your game user files* you will find a chatlog named Aug31Dragon.log to open and then copy and paste into the parsing boxes.

		<P CLASS="menu"><I>* Your game user files can be found on your hard drive at C:Documents and Settings\Computer Username\My Documents\Electronic Arts\Dark Age of Camelot\ for most.</I></P>

		<P><A HREF="http://support.darkageofcamelot.com/kb/article.php?id=771" TARGET="_blank">From Patch Notes:  1.71 Release Notes, August 24, 2004</A>
		- Added a new command, '/chatlog name', to allow players to open a chat log to a different filename than 'chat.log'. The extension '.log' is automatically appended to whatever name you choose, so typing '/chatlog pendtest' would create a file called 'pendtest.log' in your Camelot directory. You can close the chatlog by pressing your bound Chat Logging key or by typing '/chatlog' again.
		</TD>
	</TR>
	</TABLE></CENTER>
LOGNOTES;
	html_foot();
	die();}

// ~*~ Notes on how to install and use
function install_notes()
	{html_head('- Notes:  Install and Use Instructions');
	html_body();
	echo <<<INSTALLNOTES
	<CENTER>
	<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
	<TR><TH>INSTALL/USE INSTRUCTIONS</TH></TR>
	<TR>
		<TD><B>INSTALL:</B><BR>This script requires php5x and MySQL5.x (though will work on many php4x/mysql4x systems).  Windows servers may handle data differently as this script has only been tested on Unix/Linux based servers.

		<P>If you have both, you will create your database, username and password via your host's control panel or whatever method they choose, then please open &quot;config.php&quot; in a text editor (such as notepad - NOT A WORD PROCESSOR such as Word or Wordpad) and edit your Database information:
		<UL><LI>user:  your database username, this is set by you when you created the database.
		<LI>password:  your database password, this is set by you when you created the database.
		<LI>database:  this is your database &quot;name&quot;, given at time of database creation
		<LI>dbserver:  this is your actual mysql server name.  Some hosts will allow &quot;localhost&quot; to be used, but most shared hosting have server names such as mysql.hostname.com.
		</UL>
		<P>Once you have made your changes in the config.php - upload all files to your host.  You should have 3 files in your main directory (this can be a subdirectory):
		<UL><LI>index.php
		<LI>seren-sorter.gif
		<LI>sf.gif</UL>
		And a subdirectory named &quot;admin&quot; will go inside your main directory and include 11 files:
		<UL><LI>admin.php
		<LI>adminMenu.php
		<LI>config.php
		<LI>functions.php
		<LI>html.php
		<LI>index.php
		<LI>roll-setup-db.php
		<LI>search.php
		<LI>start.php</UL>

		<P>Each of these files, other than the images (*.gif files), should be uploaded in ASCII mode (images in Binary mode ;).

		<P>You will then use your web browser to go to roll-setup-db.php, if you used a subdirectory of your site named &quot;roll&quot; as your main directory, the URL would look similar to this:

		<P>http://yourdomain.com/roll/admin/roll-setup-db.php

		<P>This script will set up the tables in your database for use.  <I>Please Note:  these tables are prefaced with &quot;Seren_&quot; so that you can use the same database for multiple scripts.</I>  You should then see a successful message and you are ready to use the script, roll-setup-db.php should now be deleted from the server - it will not be needed again (leaving it on the server poses a risk that someone with ill intent will use it again possibly deleting any data in your database).

		<P>Final Note:  The admin directory should be password protected with an .htaccess/.htpasswd combination to keep unauthorized individuals from altering raid information or purging data.  To not password this area leaves it open to outside manipulation!  (<A HREF="http://www.freewebmasterhelp.com/tutorials/htaccess/3" TARGET="_blank">Need a Tutorial?</A>)

		<P><B>USE:</B><BR>
		This script was developed for lotto style raids (random /whatever up to 4 digits - then high to low chooses item).  ID numbers show the order of the delves (and raid leaders can use these to determine placement in their pack).  The admin area index.php is for raid leader control, where the index.php in your base directory is the page you can give to your raid attendees to &quot;follow along&quot;.

		<P>To use this script you will first need to log the /random rolls and loot delves to a battlegroup (delves to a cg or group will NOT be parsed).  If you need information on creating a chat log, please look under the notes to the left: &quot;How do I log chat?&quot;.

		<P>Highlight the text in your chat log that contains the rolls and loot delves, then paste into the Sorter areas (Add Loot from Log &amp; Add Rolls from Log).  For the Roll information, complete the other 2 form areas:
		<UL><LI>Name of the Toon that performed logging is requested so &quot;You&quot; do not show up in the random list - but instead your actual toon name, this should be the name of the toon that performed the logging.
		<LI>Random Roll number (random 1 to <U>blank</U> is the cut-off (ie:  /random 1000, you would place 1000 in the box - there is a 4 digit cut-off for randoms).</UL>

		When you submit each form, the script will then sort through the log (parse it) and place the appropriate information into the database.

		<P>At this time, if you haven't, you can give the Attendee View link to your raid and allow for a break for those on your raid to load up the page and become familiar with it (as well as allowing for a bit of time to take a better look at the loot ;)

		<P>Once you have added the rolls and the loot, you then go to the Main Admin page to match up the high roll with the loot of their choice and your raid attendees can view (from their index.php page) the rolls, where they are in the cycle, the loot that has been won and what is remaining.

		<P>Once the lotto is complete (or prior to your next raid), look under &quot;Clean Up&quot; to purge the database tables of any information.

		<P><I>Though much effort has gone into the creation of this script and correcting any issues - the script and all related files are provided as is with no warranty or guarantee of any kind.  For permission to utilize this script, you must leave all copyright statements intact and as-is.  You may change the coloring of the style sheet/font choices and other CSS /HTML properties to better suit your site (these changes can be made in the file:  html.php), as well as add your own guild/site graphics (as long as you are not claiming it is your parser - give credit where due).  If you would like to know when updates have been made, please email me at <A HREF="mailto:seren@thewebwench.net">seren@thewebwench.net</A> Lotto Sorter in the subject line and your main toon name, server/realm in the body.  I will only send emails to you in relation to this script ;)</I>

		<P><I>Last but not least - Use at your own risk.</I>

		<P><B>Enjoy!</B>  I hope your raid lotto was easier to administer ;)

		</TD>
	</TR>
	</TABLE></CENTER>
INSTALLNOTES;
	html_foot();
	die();}

// ~*~ Version Notes
function version_notes()
	{html_head(' - Notes:  Version Notes');
	html_body();
	echo <<<VERSIONNOTES
	<CENTER>
	<TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
	<TR><TH WIDTH="100%">SCRIPT HISTORY</TH></TR>
	<TR><TD>
	<b>2.7a</b> January 18, 2010<br>
	Thank you Amy of Gaheris for pointing out an issue:<br>
	<dl>
		<dd>&quot;When adding a roll not contained in the log manually prior to parsing the rolls, the addition shows as the first roll instead of sorting properly&quot;</dl>
	<br>Well of course it does!  Oh.. umm... yeah.  I immediately knew why, as I'd not thought of someone adding a roll manually BEFORE parsing the log.  This has now been corrected in this version.
	<p><i>Admin file(s) changed with this update:  functions.php, html.php</i>
	<p>If updating the script (not a new install):
		<ul>	<li>Replace above Admin files with new</ul>
	
	<p><b>2.7</b> May 25th, 2009<br>
	Did a bit of housecleaning with some of the code, and added a timestamp feature.  From the feedback I've been getting, it seems as though many share the same install with multiple people and some are not good at &quot;cleaning up&quot; after their raid - leaving a new raid, sometimes days later, wondering if they are interupting.  I have added a timestamp to state when a new Lotto parse has started.  This timestamp is an includes file on the Main Admin Page, directly under the logo.  Upon parsing for loot, timestamp.txt will be updated with the date/time and not overwritten until the next loot parse.

	<p><i>Admin file(s) changed with this update:  admin.php, functions.php, html.php</i><br>
	<i>File(s) added this update:  timestamp.txt (located in admin area).</i>
	<p>If updating the script (not a new install):
	<ul>
		<li>Replace above Admin files with new
		<li>Upload timestamp.txt to admin directory
	</ul>


	<p><B>2.6:</B>  May 4th, 2008<BR>
	When this script was first developed, it was written for large raids with oodles of loot (ML9, Sidi, etc).  These days, though it is still used on the raids it was originally intended for - it tends to be used on &quot;small man&quot; raids even more often.  On these smaller raids there is often more loot than people.  With this in mind, added a new feature that allows you to re-populate the roll listing without reparsing the log file as well as some other stuff:

	<UL>
		<LI>Added the ability to choose to run your Lotto by Decending (High to Low) or Ascending (Low to High).  The default is High to Low, easily changed with the click of a radio button on the roll parsing form.
		<LI>Upon initial parsing of rolls, the roll information is now stored in two tables.  When the first round of selections is complete and you have loot remaining, you can now use one of two new links in the <b>Roll Setup</b> area:
		<UL>
			<LI>Rolls from Table (Low to High)  -  Lowest Roll to Highest Roll
			<LI>Rolls from Table (High to Low)  -  Highest Roll to Lowest Roll
		</UL>
		Adding a missing roll, or removing a roll will update both Roll tables, if someone is just passing one round - use the &quot;pass&quot; feature on the winner matching page instead of removing their roll.

		<LI>Added a &quot;Purge All&quot; link to purge Rolls, Loot, and Winners at one time verses each individually.  The individual purges remain - for instances where only one needs to be cleared.
	</UL>

	<P><i>Main file(s) changed with this update:  index.php</i><br>
	<i>Admin file(s) changed with this update:  index.php, admin.php, adminMenu.php, html.php, functions.php, roll-setup-db.php</i>

		<P>If updating the script (not a new install):
		<UL>
			<LI>Replace the above files with the new
			<LI>Drop the Lotto tables from your mysql db (done via phpmyadmin or similar database management tool - the tables for this script all have the preface of <I>seren_</I>)
			<LI>Go to roll-setup-db.php in your browser and then delete it from your server after successful table creation.
	</UL>

	<p><B>2.5:</B>  August 16th, 2007<BR>
	<UL>
		<LI>Added default value of 1 to manually added items, this can be overwritten by just changing the 1 to the amount needed.
		<LI>Added &quot;Roll Numbering&quot; to both the Raid View page and Main Admin page as suggested by Lundon of Pellinor</UL>

	<P><I>Main File(s) changed with this update:  index.php<BR>
	Admin File(s) changed with this update:  html.php, functions.php, admin.php, roll-setup-db.php</I>

	<P>If updating the script (not a new install):
	<UL>
		<LI>Replace the above files with the new
		<LI>Drop the Lotto tables from your mysql db (done via phpmyadmin or similar database management tool - the tables for this script all have the preface of <I>seren_</I>)
		<LI>Go to roll-setup-db.php in your browser and then delete it from your server after successful table creation.
	</UL>

	<P><B>2.4:</B>  July 30th, 2007<BR>
	Added a new feature as suggested by Wyllow of Ector:
	<UL>
		<LI>Addition of a form to manually add a loot item, for times when someone would win 2 items with one roll (such as dragon raids, 1 of each stone) or when an item just missed the delve.  This new form can be found on the menu under &quot;Roll Setup&quot; and will allow you to type in the loot item and how many occurrences.

	</UL>
		<P>Corrected a small bug only effecting undoing a win of someone with an especially long name (this will require you to either drop the tables for this script in your database and re-run the new roll-setup-db.php - or manually reset any fields that are 30 in length to 60 via your hosts' phpmyadmin or other mysql database interface).
		<P>Also Updated Chat logging notes per the Windows Vista changes Mythic made relating to file placement.

		<P><I>Admin File(s) changed with this update:  html.php, functions.php, roll-setup-db.php, adminMenu.php.</I>

	<P><B>2.3:</B>  September 24, 2006<BR>
	Well, another Sidi raid come &amp; gone and no new unintended features found.  During a Wishlist Arti raid a small issue was found:
	<UL>
	<LI>When undoing a win the &quot;Pass&quot; choices were still going back up to the loot table.  This I believe has now been corrected.
	<LI>Started packaging script up for those that have requested to be able to install to their own servers.
	<LI>Special thanks to Kelretic-Lancelot for being my first Beta Installer - and helping stomp out some pesky issues.</UL>

	<P>August 21, 2006<BR>
	With trepidation, &quot;BETA&quot; is removed.  Since the last fixes there have been an additional 9 tests with no further issues found.  That of course does not infer there are no more issues, only none found ;)  So, BETA removed, wheeeeee!
	<UL><LI>Added Jump links on Raid Attendee page to quickly get to wins or back to the top of the page for larger raids.
	<LI>Added border to footer box.
	<LI>Cleaned up interior (coding) notes, and added more in depth content in the NOTES area linked from the admin menu.</UL>

	<P>
	<B>2.2:</B>  August 6, 2006<BR>
	Second beta test, ML9 led by Falden (Gaheris).  Sometimes you just have a, well.. a &quot;duh&quot; moment:
	<UL><LI>Items with apostrophes now enter the winner tables in the database too (should've thought of that when I fixed the loot table /sigh ).
	<LI>Winners will now only win 1 of any same named item (not all items of the same name if there are more than 1).
	<LI>When Undoing a Win where the raid attendee is getting another choice (more loot than rollers), it will not undo all wins, only the specifically chosen win.</UL>
	Per suggestions, added:
	<UL><LI>Viewable ID numbering for numbered lotto method.
	<LI>Link in Menu to &quot;Quick Jump&quot; to the Winner Match submit button</UL>

	<B>2.1:</B>  July 29, 2006 (Beta)<BR>
	First real test, Caer Sidi led by Edenslams (Iseult) -  or otherwise known as:  the day the sorter failed.  Three main issues found and corrected:
	<UL><LI>Items with apostrophes will now enter the database and show on the admin and raid attendee view.
	<LI>Rolls from players on clustered servers will now be properly parsed and added to the roll database.
	<LI>Corrected &quot;Remove a Loot Item&quot; so that it will only remove 1 item of same named loot instead of all instances of it.</UL>
	Per suggestions, added:
	<UL><LI>Total Roll Count Remaining to Main Admin and Raid Attendee Pages
	<LI>Total Loot Count Remaining to Main Admin and Raid Attendee Pages
	<LI>&quot;Delved by:&quot; addition to loot area, to quickly see non-raidleader delves, or who's pack it came from when loot spans more than 1 treasurer.
	<LI>Changed Main Admin, Attendee View, and Remove a Loot item loot information to show in Alphabetical descending order for better viewing and quicker matching.
	<LI>Special thanks to Eden for being a willing guinea pig *cough*oops, raidleader*cough* and upbeat even in failure.
	</UL>


	<B>2.0:</B>  July 26, 2006<BR>
	Version 2? So soon?  Yeah, well.. sometimes you just have to nearly start over...
	<UL><LI>Complete organizational overhaul (back end) to provide added security, easier setup, easier future updates and just generally get rid of some crappy coding.  The script will now use less server resources to run, and is better protected from malicious attempts to alter functions.
	<LI>Added Header Image
	<LI>Corrected the ability to manually add a roll of zero
	<LI>When Undoing a win that was previously set as a &quot;Player has chosen to pass&quot;, loot database will no longer have an item named [Pass]
	<LI>Separated admin directory from the Attendee View page so that it can be password protected to avoid outside interference.</UL>


	<P><B>1.2:</B>  July 24, 2006
	<UL><LI>Feature &quot;Undo Win&quot; added to remove a win and place the roller and item back so they can choose a different item.
	<LI>Added safety check for GET
	</UL>

	<P><B>1.1:</B>  July 23, 2006 - Per first rounds of ALPHA testing, reorganized layout and added features:<BR>
	<UL>
		<LI>Separated Log parsing into 2 pages (Add Loot and Add Rolls from Log) to decrease confusion.
		<LI>Added &quot;Add a Roll&quot; feature for late roll or proxy roll addition to database
		<LI>Added &quot;Remove a Roll&quot; feature for the ability to remove invalid (drive-by) rolls or those who have left and do not want to partake.
		<LI>Added &quot;Remove a Loot Item&quot; to remove items mistakenly delved (what? it happens.. that sleeping kitten is NOT up for grabs!).
		<LI>Renamed some of the admin choices to increase clarity
		<LI>Added notes section to menu
		<LI>Added additional Error Trapping in various portions of the script so raid leader will know what went wrong (instead of a pretty little blank screen).
		<LI>Merged files for easier personal install.
		<LI>Added &quot;Serenity Faith&quot; logo.
	</UL>
	Thank you to my script testers, their unintended feature finding and suggestions.

	<P><B>1.0:</B>  July 18, 2006 - Original (Pre-)Release of script (Alpha).  Features including:<BR>
	<UL><LI>Chat Log Parser (for rolls and loot)
	<LI>Main Admin page to manage Lotto
	<LI>Table Purge to clear data
	<LI>Attendee View page for raid attendees to see the winner order and loot available, as well as the items that have been won and their winner
	</UL>


	</TD></TR>
	</TABLE>
	</CENTER>
VERSIONNOTES;
	html_foot();
	die();}


// ~*~ Chat log parse for Raid Rolls - Create form
function add_roll_form()
	{html_head(' - Add Chat Log for Rolls');
	html_body();
	echo <<<ADDROLLS
	<CENTER>
	<TABLE BORDER="0" WIDTH="90%" CELLPADDING="6" CELLSPACING="0">
	<TR><TH colspan="2" WIDTH="100%">Number Sorter</TH></TR>
	<TR>
		<TD colspan="2">Copy your chat log with /random information in the box below - only random's will be sorted from this log and added to the database.</TD>
	</tr>
	<tr>
		<TD valign="top"><FORM METHOD="POST" ACTION="functions.php?action=btcRandom" TARGET="main">
		Name of the Toon that performed logging:  <INPUT NAME="raidleader" TYPE="TEXT" SIZE="20" MAXLENGTH="20"><BR>
		Random 1 to:  <INPUT NAME="maxroll" TYPE="TEXT" SIZE="8" MAXLENGTH="8"></td>
		<td valign="top"><input type="radio" name="order" value="desc" checked="checked"> Decending (High to Low)<br>
		<input type="radio" name="order" value="asc"> Acending (Low to High)</td>
	</tr>
	<tr>
		<td colspan="2" align="center">
		<textarea name="random" rows="16" cols="80"></textarea><BR>
		<INPUT TYPE="submit" VALUE="Input Rolls">
		</FORM></TD></TR></TABLE></CENTER>
ADDROLLS;
	html_foot();
	die();}

// ~*~ Chatlog parse for Raid Loots - Create form
function add_loot_form()
	{html_head('  - Add Chat Log for Loot');
	html_body();
	echo <<<ADDLOOTS
	<CENTER>
	<TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
	<TR><TH>Loot Sorter</TH></TR>
	<TR>
		<TD>Copy your chat log with the loot information in the box below - only loot will be sorted from this log and added to the database.

		<P ALIGN="center">
		<FORM METHOD="POST" ACTION="functions.php?action=btcLoot" TARGET="main">

		<textarea name="MadLoots" rows="16" cols="80"></textarea><BR>
		<INPUT TYPE="submit" VALUE="Input Loot">
		</FORM>
		</TD>
	</TR></TABLE></CENTER>
ADDLOOTS;
	html_foot();
	die();}

// ~*~ Removal of Loot Item, in case of mistaken delve
function loot_be_gone()
	{$itemremove = $_POST['itemremove'];
	$LootBeGone = $_POST['LootBeGone'];

	if ($LootBeGone == "")
		{html_head(' - Remove Item of Loot from Database');
		html_body();

		echo <<<TABLETOP
		<CENTER>
		<!-- table 1, roll information -->
		<FORM METHOD="POST" ACTION="functions.php?action=RemoveItem">
		<TABLE BORDER="0" WIDTH="90%" CELLSPACING="2">
		<TR><TH>REMOVE LOOT ITEM</TH></TR>
		<TR><TD>
		<TABLE BORDER="0" CELLPADDING="2" WIDTH="100%">
		<!-- round robin of delved items -->
TABLETOP;

		$query="SELECT*FROM seren_loot ORDER BY items";
		$result=mysql_query($query);

		//count rows of data
		$num=mysql_numrows($result);

		//loop data to pull out each row at a time
		$i=0;
		while ($i < $num) {

		//assign variables
		$id=mysql_result ($result, $i, "id");
		$items=mysql_result($result,$i,"items");

		// return rows with alternate coloring for ease in viewing.
		$row=$i+1;
		if ($row % 2)
			{echo "<TR><TD CLASS=\"one\" VALIGN=\"top\"><INPUT TYPE=\"radio\" NAME=\"itemremove\" VALUE=\"$id\"></TD><TD CLASS=\"one\">$items ($id)</TD></TR>\n";}
		else
			{echo "<TR><TD VALIGN=\"top\"><INPUT TYPE=\"radio\" NAME=\"itemremove\" VALUE=\"$id\"></TD><TD>$items ($id)</TD></TR>\n";}
			$i++;
			}
		echo <<<TABLEBOTTOM
			<TR>
				<TD ALIGN="center"><INPUT TYPE="hidden" NAME="LootBeGone" VALUE="yes">
				<INPUT TYPE="submit" VALUE="Remove Item"></TD></TR>
			</TABLE></TD></TR></TABLE>
			</FORM>
			</CENTER>
TABLEBOTTOM;
		html_foot();
		die();}

	// do not allow a removal if item has not been chosen
	if ($itemremove == "")
		{html_head(' - Remove Item of Loot from Database:  ERROR');
		html_body();
		echo <<<ERRORCHOICE
		<CENTER>
		<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
		<TR><TH>ERROR!!!</TH></TR>
		<TR><TD>No Item chosen to remove.  Please go back and choose the item you would like to remove from the database.</TD></TR></TABLE>
		</CENTER>
ERRORCHOICE;

	html_foot();
	die();}

	$query = "DELETE FROM seren_loot WHERE id='$itemremove'";
	mysql_query($query);

header("Location: admin.php");
die();}


// ~*~ Add a roll, for an accepted late roll or proxy roll
function add_single_roll()
	{$RollerName = $_POST['RollerName'];
	$rollnew = $_POST['roll'];
	$rolltest = $_POST['rolltest'];
	$order2 = trim($_POST['order2']);

if ($rolltest == "")
	{html_head(' - Add a Late or Proxy Roll');
	html_body();
	echo <<<FORM

	<CENTER><TABLE BORDER="0" CELLPADDING="6" CELLSPACING="0" WIDTH="90%">
	<TR><TH COLSPAN="2" WIDTH="100%">Add a Random Roll</TH></TR>
	<TR>
		<TD colspan="2">If a roll is accepted after logging has stopped (late roll/proxy roll), the additional roll can be added to the database below.</TD>
	</tr>
	<TR>
		<TD><FORM METHOD="POST" ACTION="functions.php?action=AddLateRoll" TARGET="main">
		Roller Name:  <INPUT NAME="RollerName" TYPE="TEXT" SIZE="20" MAXLENGTH="20"><BR>
		Roll Number:  <INPUT NAME="roll" TYPE="TEXT" SIZE="8" MAXLENGTH="8"></td>
		<td valign="top">Current roll order is:<br><input type="radio" name="order2" value="desc" checked="checked"> Decending (High to Low)<br>
		<input type="radio" name="order2" value="asc"> Acending (Low to High)</td>
	</tr>
	<TR>
		<td colspan="2">
		<INPUT TYPE="hidden" NAME="rolltest" VALUE="yes">
		<INPUT TYPE="submit" VALUE="Add Roll">
	</FORM></TD></TR></TABLE></CENTER>

FORM;
	html_foot();
	die();}

// do not allow missing information, roller and roll both be there
if ($RollerName == "" || $rollnew == "")
	{html_head(' - Add a Late or Proxy Roll:  ERROR!');
	html_body();
	echo <<<ERRORMSG
		<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
		<TR><TH>ERROR!</TH></TR>
		<TR><TD>You are missing information, please go back and complete both the Roller Name and their roll</TD></TR>
		</TABLE></CENTER>
ERRORMSG;
	html_foot();
	die();}


// leave it to someone to try to add a roll of zero *sigh*, do not allow roll of 0 to be added
if ($rollnew == 0)
	{html_head('- Add a Late or Proxy Roll: ERROR!');
	html_body();
	echo <<<ERROR0
	<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
			<TR><TH>ERROR!</TH></TR>
			<TR><TD>A Roll can not have a value of 0 (zero).  Please use the back button and input the correct number.</TD></TR>
		</TABLE></CENTER>
ERROR0;
	html_foot();
	die();}

// Little bit of extra work to renumber rolls for version 2.5
$result = mysql_query("SELECT*FROM seren_roller");

// Loop each "row" of db info into array
while($row = mysql_fetch_array($result))
	{$reorder[$row['winner']] = $row['roll'];}

// Add new entry
$reorder[$RollerName] = $rollnew;

// sort it decending or ascending based on "roll"
if ($order2 == "desc")
	{arsort($reorder);}
if ($order2 == "asc")
	{asort($reorder);}

//echo '<pre>';
//echo print_r($reorder);
//echo '</pre>';
//die();


@mysql_query("TRUNCATE TABLE `seren_roller`") or die("Unable to clear Roll Data");

unset($nick, $roll, $RollOrder);
$RollOrder = 0;

foreach($reorder as $nick => $roll)
	{$RollOrder++;
	$query = "INSERT INTO seren_roller VALUES ('".$nick."','".$roll."','".$RollOrder."')";
	mysql_query($query);}

// Add the roll to the storage table too!  (v2.6)
$result02 = mysql_query("SELECT*FROM seren_roller2");

// Loop each "row" of db info into array
while($row = mysql_fetch_array($result02))
	{$reorder02[$row['winner2']] = $row['roll2'];}

// Add new entry
$reorder02[$RollerName] = $rollnew;

// sort it decending based on "roll"
arsort($reorder02);

@mysql_query("TRUNCATE TABLE `seren_roller2`") or die("Unable to clear Roll Data from seren_roller2");

unset($nick, $roll, $RollOrder);
//$RollOrder = 0;

foreach($reorder02 as $nick => $roll)
	{
	//$RollOrder++;
	$query = "INSERT INTO seren_roller2 VALUES ('".$nick."','".$roll."')";
	mysql_query($query);}


// let raid leader know it was added
html_head(' - Add a Late or Proxy Roll:  Roll Added');
html_body();
echo <<<LATEROLLADDED
<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
	<TR><TH>Roll Added</TH></TR>
	<TR><TD>$RollerName with a roll of $rollnew has been added</TD></TR>
	</TABLE></CENTER>
LATEROLLADDED;
html_foot();
die();}



// ~*~ Removal of Roll, in case of drive-by roller or invalid roll
function roll_be_gone()
	{$rollremove = $_POST['rollremove'];
	$RollBeGone = $_POST['RollBeGone'];
	$order3 = trim($_POST['order3']);

	if ($RollBeGone == "")
		{html_head(' - Remove Roll');
		html_body();

		echo <<<TABLETOP
		<CENTER>
		<!-- table 1, roll information -->
		<FORM METHOD="POST" ACTION="functions.php?action=RemoveRoll">
		<TABLE BORDER="0" WIDTH="90%" CELLSPACING="2">
		<TR><TH>REMOVE ROLL</TH></TR>
		<TR><TD>
		<TABLE BORDER="0" CELLPADDING="2" WIDTH="100%">
		<!-- round robin of delved items -->
TABLETOP;

		$query="SELECT*FROM seren_roller ORDER BY winner ASC";
		$result=mysql_query($query);

		//count rows of data
		$num=mysql_numrows($result);

		//loop data to pull out each row at a time
		$i=0;
		while ($i < $num) {

		//assign variables
		$roll=mysql_result ($result, $i, "roll");
		$winner=mysql_result($result,$i,"winner");

		// pretty colors make for easier viewing!
		$row=$i+1;
		if ($row % 2)
			{echo "<TR><TD CLASS=\"one\" VALIGN=\"top\"><INPUT TYPE=\"radio\" NAME=\"rollremove\" VALUE=\"$winner\">  $winner ($roll)</TD></TR>\n";}
		else
			{echo "<TR><TD VALIGN=\"top\"><INPUT TYPE=\"radio\" NAME=\"rollremove\" VALUE=\"$winner\">  $winner ($roll)</TD></TR>\n";}
			$i++;
			}
		echo <<<TABLEBOTTOM
<TR>
		<TD>Current roll order is:<br><input type="radio" name="order3" value="desc" checked="checked"> Decending (High to Low)<br>
		<input type="radio" name="order3" value="asc"> Acending (Low to High)</td>
	</tr>
	<tr>
		<td align="center">
		<INPUT TYPE="hidden" NAME="RollBeGone" VALUE="yes">
		<INPUT TYPE="submit" VALUE="Remove Roll"></TD></TR>
		</TABLE></TD></TR></TABLE>
		</FORM>
		</CENTER>
TABLEBOTTOM;
		html_foot();
		die();}

	if ($rollremove == "")
		{html_head(' - Remove Roll:  ERROR!');
		html_body();
		echo <<<ERRORCHOICE
		<CENTER>
		<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
		<TR><TH>ERROR!!!</TH></TR>
		<TR><TD>No Roll chosen to remove.  Please go back and choose the roll you would like to remove from the database.</TD></TR></TABLE>
		</CENTER>
ERRORCHOICE;

	html_foot();
	die();}

$query = "DELETE FROM seren_roller WHERE winner='$rollremove'";
mysql_query($query);

$result = mysql_query("SELECT*FROM seren_roller");

while($row = mysql_fetch_array($result))
	{$reorder[$row['winner']] = $row['roll'];}

// sort it decending or ascending based on "roll"
if ($order3 == "desc")
	{arsort($reorder);}
if ($order3 == "asc")
	{asort($reorder);}

@mysql_query("TRUNCATE TABLE `seren_roller`") or die("Unable to clear Roll Data");

unset($nick, $roll, $RollOrder);
$RollOrder = 0;

foreach($reorder as $nick => $roll)
	{$RollOrder++;
	$query = "INSERT INTO seren_roller VALUES ('".$nick."','".$roll."','".$RollOrder."')";
	mysql_query($query);}

// Remove roll from storage table too!  (v2.6)
$query = "DELETE FROM seren_roller2 WHERE winner2='$rollremove'";
mysql_query($query);

//$result = mysql_query("SELECT*FROM seren_roller2");
//
//while($row = mysql_fetch_array($result))
//	{$reorder03[$row['winner']] = $row['roll'];}
//
//arsort($reorder03);
//
//
//@mysql_query("TRUNCATE TABLE `seren_roller2`") or die("Unable to clear Roll Data from seren_roller2");
//
//unset($nick, $roll, $RollOrder);
//
//foreach($reorder03 as $nick => $roll)
//	{$query = "INSERT INTO seren_roller2 VALUES ('".$nick."','".$roll."')";
//	mysql_query($query);}

// let raid leader know Roll was removed
html_head(' - Remove Roll:  Roll Has Been Removed');
html_body();
echo <<<ROLLREMOVED
<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
	<TR><TH>Roll Removed</TH></TR>
	<TR><TD>$rollremove has been removed</TD></TR>
	</TABLE></CENTER>
ROLLREMOVED;
html_foot();


die();}


// ~*~ Drop data from Winner table (purge data)
function drop_winner()
	{@mysql_query("TRUNCATE TABLE `seren_winners`") or die("Unable to clear Winner Data");

	html_head(' - Purge Winner Table');
	html_body();

	echo <<<DROPWINNER
	<CENTER>
	<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
	<TR><TH>Purge Winners</TH></TR>
	<TR><TD>Winner Table Cleared for next use</TD></TR>
	</TABLE>
	</CENTER>
DROPWINNER;
	html_foot();
	die();}


// ~*~ Drop data from rolls table (purge data)
function drop_rolls()
	{@mysql_query("TRUNCATE TABLE `seren_roller`") or die("Unable to clear Roll Data");
	@mysql_query("TRUNCATE TABLE `seren_roller2`") or die("Unable to clear Roll Data Storage Table 2");


	html_head(' - Purge Rolls Table');
	html_body();

	echo <<<DROPROLLS
	<CENTER>
	<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
	<TR><TH>Purge Rolls</TH></TR>
	<TR><TD>Rolls Table Cleared for next use</TD></TR>
	</TABLE>
	</CENTER>
DROPROLLS;
	html_foot();
	die();}


// ~*~ Drop data from Loot table (purge data)
function drop_loot()
	{@mysql_query("TRUNCATE TABLE `seren_loot`") or die("Unable to clear Loot Data");

	html_head(' - Purge Loot Table');
	html_body();

	echo <<<DROPLOOT
	<CENTER>
	<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
	<TR><TH>Purge Loot</TH></TR>
	<TR><TD>Loot Table Cleared for next use</TD></TR>
	</TABLE>
	</CENTER>
DROPLOOT;
	html_foot();
	die();}

// ~*~ Drop data from all tables (purge data) v2.6
function drop_all()
	{@mysql_query("TRUNCATE TABLE `seren_winners`") or die("Unable to clear Winner Data");
	@mysql_query("TRUNCATE TABLE `seren_roller`") or die("Unable to clear Roll Data");
	@mysql_query("TRUNCATE TABLE `seren_loot`") or die("Unable to clear Loot Data");
	@mysql_query("TRUNCATE TABLE `seren_roller2`") or die("Unable to clear Roll Data Storage Table 2");


	html_head(' - Purge All Tables');
	html_body();

	echo <<<DROPALL
	<CENTER>
	<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
	<TR><TH>Purge All Data</TH></TR>
	<TR><TD>All  Tables Cleared for next use</TD></TR>
	</TABLE>
	</CENTER>
DROPALL;
	html_foot();
	die();}


// ~*~ Removal of Win, in case of mistaken choice (or, yes, we can admit it - incorrect match)
function undo_win()
	{$winremove = $_POST['winremove'];
	$WinBeGone = $_POST['WinBeGone'];

	if ($WinBeGone == "")
		{html_head('- Remove Win');
		html_body();

		echo <<<TABLETOP
<CENTER>
<FORM METHOD="POST" ACTION="functions.php?action=undoWin">
<TABLE BORDER="0" WIDTH="90%" CELLSPACING="2">
<TR><TH>REMOVE WIN</TH></TR>
<TR>
	<TD>
	<TABLE BORDER="0" CELLPADDING="2" WIDTH="100%">
TABLETOP;

		$query="SELECT*FROM seren_winners ORDER BY winnerName ASC";
		$result=mysql_query($query);

		//count rows of data
		$num=mysql_numrows($result);

		//loop data to pull out each row at a time
		$i=0;
		while ($i < $num) {

		//assign variables
		$winnerName=mysql_result ($result, $i, "winnerName");
		$itemWon=mysql_result($result,$i,"itemWon");
		$itemID=mysql_result($result,$i,"itemID");

		$row=$i+1;
		if ($row % 2)
			{echo "<TR><TD CLASS=\"one\" VALIGN=\"top\"><INPUT TYPE=\"radio\" NAME=\"winremove\" VALUE=\"$itemID $winnerName $itemWon\">$winnerName:  $itemWon <FONT CLASS=\"menu\"><I>ID:  $itemID</I></FONT></TD></TR>\n";}
		else
			{echo "<TR><TD VALIGN=\"top\"><INPUT TYPE=\"radio\" NAME=\"winremove\" VALUE=\"$itemID $winnerName $itemWon\">$winnerName:  $itemWon <FONT CLASS=\"menu\"><I>ID:  $itemID</I></FONT></TD></TR>\n";}
			$i++;
			}
		echo <<<TABLEBOTTOM
			<TR>
				<TD ALIGN="center"><INPUT TYPE="hidden" NAME="WinBeGone" VALUE="yes">
				<INPUT TYPE="submit" VALUE="Remove Win"></TD></TR>
			</TABLE></TD></TR></TABLE>
			</FORM>
			</CENTER>
TABLEBOTTOM;
		html_foot();
		die();}

	if ($winremove == "")
		{$title = "ERROR";
		html_head('- Remove Win:  ERROR!');
		html_body();
		echo <<<ERRORREMOVEWIN
		<CENTER>
		<TABLE BORDER="0" CELLPADDING="6" WIDTH="90%">
		<TR><TH>ERROR!!!</TH></TR>
		<TR><TD>No Win chosen to remove.  Please go back and choose the win you would like to remove from the database.</TD></TR></TABLE>
		</CENTER>
ERRORREMOVEWIN;

	html_foot();
	die();}

// oooooo.. regex, my fav! *groan*
// going to separate the info from the form into 4 parts, itemID, winner, number and item, remove from winners, add into loot and roller

preg_match_all("/(.+?) (.+?) \((.+?)\) \[(.+?)\]\: (.+?)$/ims", $winremove, $match3);

//echo '<pre>';
//echo print_r($match3);
//echo '</pre>';
//die();

$query = "DELETE FROM seren_winners WHERE winnerName='".$match3[2][0]." \(".$match3[3][0]."\)' && itemID='".$match3[1][0]."'";
mysql_query($query);

if ($match3[4][0] != "Pass")
	{$query = "INSERT INTO seren_loot VALUES ('".$match3[1][0]."','[".mysql_real_escape_string($match3[4][0])."]: ".$match3[5][0]."')";
	mysql_query($query);}

$query = "INSERT INTO seren_roller VALUES ('".$match3[2][0]."','".$match3[3][0]."','')";
mysql_query($query);

header("Location: admin.php");
die();}


// ~*~ Remove Loot & Roller from tables, add them to Won table
function add_win()
	{$item = $_POST['item'];
	$winnerList = $_POST['winnerList'];

	if ($item == "" || $winnerList == "")
		{html_head(' - Add Winner:  ERROR!');
		html_body();
		echo <<<ERRORMATCH
		<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
		<TR><TH>ERROR!</TH></TR>
		<TR><TD>Either an Item or an Item Winner was not chosen, please go <A HREF="admin.php" TARGET="main">back</A> and select one of each.</TD></TR>
		</TABLE></CENTER>
ERRORMATCH;
		html_body();
		die();}

	// searching for Item name only for raid leader view (they have enough to deal with)
	preg_match_all("/(.+?) \[(.+?)\]\: (.+?)$/ims", $item, $match);
	preg_match_all("/(.+?)\s\((.+?)\)/ims", $winnerList, $match2);

	// adding winner information into winners table
	$query = "INSERT INTO seren_winners VALUES ('$winnerList','".$match[1][0]."','[".mysql_real_escape_string($match[2][0])."]','[".mysql_real_escape_string($match[2][0])."]: ".mysql_real_escape_string($match[3][0])."')";
	mysql_query($query);

	$query = "DELETE FROM seren_loot WHERE id='".$match[1][0]."'";
	mysql_query($query);

	$query = "DELETE FROM seren_roller WHERE winner='".$match2[1][0]."'";
	mysql_query($query);

	header("Location: admin.php");
	die();}


// ~*~ Parse chatlog for random roll names and number, ensuring number is within proper range
// Amy found a bug!  Correcting (18-Jan-2010)
function btc_random()
	{$data = stripslashes($_POST['random']);
	$maxroll = (int) trim($_POST['maxroll']);
	$raidleader = trim($_POST['raidleader']);
	$order = trim($_POST['order']);

	if ($raidleader == "" || $maxroll == "")
		{html_head(' - Add Random Rolls:  ERROR!');
		html_body();
		echo <<<ERRORMSG
		<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
		<TR><TH>ERROR!</TH></TR>
		<TR><TD>You did not complete the Raid Leader or Max Roll area, please go back and complete those areas then try again.</TD></TR>
		</TABLE></CENTER>
ERRORMSG;
		html_foot();
	die();}

	if ($data == "")
		{html_head(' - Add Random Rolls:  ERROR!');
		html_body();
		echo <<<ERRORLOGDATA
		<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
		<TR><TH>ERROR!</TH></TR>
		<TR><TD>There was no Chat Log pasted into the text box!  Please go back and paste your chatlog so it can be parsed.</TD></TR>
		</TABLE></CENTER>
ERRORLOGDATA;
		html_foot();
	die();}

	preg_match_all("/([\w-]+) (pick|picks) a random number between 1 and ".$maxroll.": (\d+)/", $data, $matches);

//echo '<pre>';
//echo print_r($matches);
//echo '</pre>';
//die();

	$tot = (count($matches[1]) - 1);
	$i = 0;
	$newdata = array();
	while($i <= $tot)
		{if (!isset($newdata[$matches[1][$i]]))
			{$newdata[$matches[1][$i]] = $matches[3][$i];}
		$i++;}

// Add in any rolls already in DB here, prior to sort and replacement  (2.7a)
	
	$query="SELECT*FROM seren_roller ORDER BY RollOrder ASC";
	$result=mysql_query($query);

	//count rows of data
	$num=mysql_numrows($result);

	//loop data to pull out each row at a time
	$i=0;
	while ($i < $num) {

	//assign variables
	$winner=mysql_result($result,$i,"winner");
	$roll=mysql_result($result,$i,"roll");
	$rollOrder=mysql_result($result,$i,"RollOrder");
	
	$newdata[$winner] = $roll;
	$i++;}

	@mysql_query("TRUNCATE TABLE `seren_roller`") or die("Unable to clear Roll Data");
	@mysql_query("TRUNCATE TABLE `seren_roller2`") or die("Unable to clear Roll Data from seren_roller2");

		// Sort Array based on Roll before placing into DB
		if ($order == "desc")
			{arsort($newdata);}
		if ($order == "asc")
			{asort($newdata);}

	// checking to make sure that "you" is changed to the actual raid leader name
	unset($nick, $roll);
	$RollOrder = 0;

	foreach($newdata as $nick => $roll)
		{if ($nick == "You")
			{$nick = $raidleader;}
		$RollOrder++;

		$query = "INSERT INTO seren_roller VALUES ('".$nick."','".$roll."','".$RollOrder."')";
		mysql_query($query);}


	// need to now add to storage table of rolls (v2.6)
	$query = "INSERT INTO seren_roller2 (winner2,roll2) SELECT seren_roller.winner,seren_roller.roll FROM seren_roller";
	mysql_query($query);

	header("Location: admin.php");
	die();}


// ~*~ Grab stored rolled for re-use (v2.6)
function storage_asc()
	{$resultFromStorage = mysql_query("SELECT*FROM seren_roller2");

	// Loop each "row" of db info into array
	while($row2 = mysql_fetch_array($resultFromStorage))
		{$reorder2[$row2['winner2']] = $row2['roll2'];}

	// sort it acending based on "roll"
	asort($reorder2);

	unset($nick, $roll, $RollOrder);
	$RollOrder = 0;

	foreach($reorder2 as $nick => $roll)
		{$RollOrder++;
		$query = "INSERT INTO seren_roller VALUES ('".$nick."','".$roll."','".$RollOrder."')";
		mysql_query($query);}

	header("Location: admin.php");
	die();}

function storage_desc()
	{$resultFromStorage = mysql_query("SELECT*FROM seren_roller2");

	// Loop each "row" of db info into array
	while($row2 = mysql_fetch_array($resultFromStorage))
		{$reorder2[$row2['winner2']] = $row2['roll2'];}

	// sort it acending based on "roll"
	arsort($reorder2);

	unset($nick, $roll, $RollOrder);
	$RollOrder = 0;

	foreach($reorder2 as $nick => $roll)
		{$RollOrder++;
		$query = "INSERT INTO seren_roller VALUES ('".$nick."','".$roll."','".$RollOrder."')";
		mysql_query($query);}

	header("Location: admin.php");
	die();}


// ~*~ Parse chatlog for loot data
function btc_loot()
	{$data=stripslashes($_POST['MadLoots']);

	if ($data == "")
		{html_head(' - Add Loot to Database:  ERROR!');
		html_body();
		echo <<<ERRORLOGDATA
		<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
		<TR><TH>ERROR!</TH></TR>
		<TR><TD>There was no Chat Log pasted into the text box!  Please go back and paste your chatlog so it can be parsed.</TD></TR>
		</TABLE></CENTER>
ERRORLOGDATA;
		html_foot();
		die();}

	preg_match_all("/.*\[BattleGroup\].*\ (.+?)\/Item: \"- \[(.+?)\]\: (.+?)\"/", $data, $matches);
	// ugly isn't it?  ^^^

	//Time stamp added in 25-May-2009 - shows only within Admin, v2.7
	$timestampdate = date('d-M-Y g:i a T');

	$fp = fopen('timestamp.txt', 'w');
	fwrite($fp, $timestampdate);
	fclose($fp);

	$tot = (count($matches[1]) - 1);
	$i = 0;
	while($i <= $tot)
		{//echo '<pre>', print_r($matches, true), '</pre>';

		$query = "INSERT INTO seren_loot VALUES ('','[".mysql_real_escape_string($matches[2][$i])."]: ".mysql_real_escape_string($matches[3][$i])." <BR><FONT CLASS=menu><I>Delved by: ".$matches[1][$i]."</I></FONT>')";
		mysql_query($query);
		$i++;}

header("Location: admin.php");
die();}


function manual_loot_form()
	{html_head('  - Add Loot Items Manually');
	html_body();
	echo <<<ADDLOOTSMANUALLY
	<CENTER>
	<TABLE BORDER="0" WIDTH="90%" CELLPADDING="6" CELLSPACING="0">
	<TR><TH>Manually add Loot Item</TH></TR>
	<TR>
		<TD>Utilize this form you would like to manually add loot item(s), either after delving is complete or when the &quot;win&quot; is a combination of items (such as 1 of each stone on a dragon raid).

		<P>Type in Item name and how many occurrences to place in the Lotto database.</TD>
	</TR>

	<TR>
		<TD VALIGN="center">
		<FORM METHOD="POST" ACTION="functions.php?action=btcLootManual" TARGET="main">
		<TABLE BORDER="0">
		<TR>
			<TD>Name of Item to add:</TD>
			<TD><INPUT NAME="manualItem" TYPE="TEXT" SIZE="40" MAXLENGTH="40"></TD>
			<TD>Amount:</TD>
			<TD><INPUT NAME="manualItemAmount" TYPE="TEXT" SIZE="4" MAXLENGTH="4" VALUE="1"></TD>
		</TR>
		</TABLE>
		<P ALIGN="center"><INPUT TYPE="submit" VALUE="Input Item">
		</FORM>
		</TD>
	</TR></TABLE></CENTER>
ADDLOOTSMANUALLY;
	html_foot();
	die();}


// ~*~ Add to db manually entered loot items
function btc_loot_manual()
	{$data=stripslashes($_POST['manualItem']);
	$manualAmount=stripslashes($_POST['manualItemAmount']);

	if ($data == "")
		{html_head(' - Add Loot to Database:  ERROR!');
		html_body();
		echo <<<ERRORLOGDATA
		<CENTER><TABLE BORDER="0" WIDTH="90%" CELLPADDING="6">
		<TR><TH>ERROR!</TH></TR>
		<TR><TD>There was no Item added!  Please go back and the item if you would like it added to the Lotto database.</TD></TR>
		</TABLE></CENTER>
ERRORLOGDATA;
		html_foot();
		die();}

//	$tot = (count($matches[1]) - 1);
//	$i = 0;
//	while($i <= $tot)
//		{//echo '<pre>', print_r($matches, true), '</pre>';


// add foreach loop for manualItemAmount
	$manualTally = '1';

	while($manualTally <= $manualAmount)
		{$query = "INSERT INTO seren_loot VALUES ('','[Manually Entered Item]: ".mysql_real_escape_string($data)."')";
		mysql_query($query);
		$manualTally++;}
header("Location: admin.php");
die();}




// Why are you reading this?  It's done...
?>